/**
 * SaaS OS Tokens — Free Edition
 * Source of truth: CSS variables generated from Figma
 * Do not inline raw values.
 * Always reference CSS variables.
 */

export const tokens = {
    color: {
      text: {
        primary: "var(--color_text_primary)",
        secondary: "var(--color_text_secondary)",
        muted: "var(--color_text_muted)",
        inverse: "var(--color_text_inverse)"
      },
      bg: {
        page: "var(--color_bg_page)",
        surface: "var(--color_bg_surface)",
        subtle: "var(--color_bg_subtle)",
        overlay: "var(--color_bg_overlay)"
      },
      border: {
        default: "var(--color_border_default)",
        subtle: "var(--color_border_subtle)",
        strong: "var(--color_border_strong)"
      },
      action: {
        primary: "var(--color_action_primary)",
        primaryHover: "var(--color_action_primary_hover)",
        primaryActive: "var(--color_action_primary_active)",
        primaryText: "var(--color_action_primary_text)"
      },
      status: {
        success: "var(--color_status_success)",
        warning: "var(--color_status_warning)",
        error: "var(--color_status_error)"
      },
      surface: {
        success: "var(--color_surface_success)",
        warning: "var(--color_surface_warning)",
        error: "var(--color_surface_error)",
        info: "var(--color_surface_info)"
      },
      focus: {
        ring: "var(--color_focus_ring)",
        ringOffset: "var(--color_focus_ring_offset)",
        ringError: "var(--color_focus_ring_error)",
        ringErrorOffset: "var(--color_focus_ring_error_offset)"
      }
    },
  
    space: {
      0: "var(--space_0)",
      1: "var(--space_1)",
      2: "var(--space_2)",
      3: "var(--space_3)",
      4: "var(--space_4)",
      5: "var(--space_5)",
      6: "var(--space_6)",
      7: "var(--space_7)",
      8: "var(--space_8)"
    },
  
    radius: {
      none: "var(--radius_none)",
      sm: "var(--radius_sm)",
      md: "var(--radius_md)",
      lg: "var(--radius_lg)",
      xl: "var(--radius_xl)",
      full: "var(--radius_full)"
    },
  
    motion: {
      fast: "var(--motion_fast)",
      base: "var(--motion_base)",
      slow: "var(--motion_slow)"
    },
  
    typography: {
      body: {
        sm: "var(--typography_body_sm)",
        md: "var(--typography_body_md)",
        lg: "var(--typography_body_lg)",
        lineHeight: "var(--typography_body_line_height)",
        fontWeight: "var(--typography_body_font_weight)"
      },
      heading: {
        sm: "var(--typography_heading_sm)",
        md: "var(--typography_heading_md)",
        lg: "var(--typography_heading_lg)",
        lineHeight: "var(--typography_heading_line_height)",
        fontWeight: "var(--typography_heading_font_weight)"
      }
    }
  } as const;

  export type Tokens = typeof tokens;